<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.111.3.9.10.29
Name: kan weg - Opvragen index met gegevensbeheerder (eigen applicatie)
Description: Deze interactie ondersteunt het opvragen van verwijzingen bij de Verwijsindex (Act Reference Registry) op basis van de parameters zoals opgegeven in de interactie, waarbij de applicatie ID verplicht is. Deze interactie dient om alle geregistreerde verwijzingen van een bepaalde applicatie op te vragen ten behoeve van synchronisatiedoeleinden. Omdat hiermee alleen gegevens kunnen worden opgehaald die hun bron hebben in de eigen applicatie, mag deze interactie worden verzonden op vertrouwensniveau laag.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" id="template-2.16.840.1.113883.2.4.3.111.3.9.10.29-2016-11-02T150800">
    <title>kan weg - Opvragen index met gegevensbeheerder (eigen applicatie)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.29
Context: /
Item: (QUMT_IN020011NL02)
-->
    <rule context="/" id="d836099e2201-false-d885565e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:QUMT_IN020011NL02)&gt;=1">(QUMT_IN020011NL02): element hl7:QUMT_IN020011NL02 is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:QUMT_IN020011NL02)&lt;=1">(QUMT_IN020011NL02): element hl7:QUMT_IN020011NL02 komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.29
Context: /hl7:QUMT_IN020011NL02
Item: (QUMT_IN020011NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02" id="d836099e2207-false-d885590e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:id[not(@nullFlavor)])&gt;=1">(QUMT_IN020011NL02): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:id[not(@nullFlavor)])&lt;=1">(QUMT_IN020011NL02): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:creationTime[not(@nullFlavor)])&gt;=1">(QUMT_IN020011NL02): element hl7:creationTime[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:creationTime[not(@nullFlavor)])&lt;=1">(QUMT_IN020011NL02): element hl7:creationTime[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)])&gt;=1">(QUMT_IN020011NL02): element hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)])&lt;=1">(QUMT_IN020011NL02): element hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:interactionId[@root='2.16.840.1.113883.1.6'])&gt;=1">(QUMT_IN020011NL02): element hl7:interactionId[@root='2.16.840.1.113883.1.6'] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:interactionId[@root='2.16.840.1.113883.1.6'])&lt;=1">(QUMT_IN020011NL02): element hl7:interactionId[@root='2.16.840.1.113883.1.6'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1'])&gt;=1">(QUMT_IN020011NL02): element hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1'] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1'])&lt;=1">(QUMT_IN020011NL02): element hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:processingCode[@code='P'][not(@nullFlavor)])&gt;=1">(QUMT_IN020011NL02): element hl7:processingCode[@code='P'][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:processingCode[@code='P'][not(@nullFlavor)])&lt;=1">(QUMT_IN020011NL02): element hl7:processingCode[@code='P'][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:processingModeCode[@code='T'][not(@nullFlavor)])&gt;=1">(QUMT_IN020011NL02): element hl7:processingModeCode[@code='T'][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:processingModeCode[@code='T'][not(@nullFlavor)])&lt;=1">(QUMT_IN020011NL02): element hl7:processingModeCode[@code='T'][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:acceptAckCode[@code='AL' or @code='NE'][not(@nullFlavor)])&gt;=1">(QUMT_IN020011NL02): element hl7:acceptAckCode[@code='AL' or @code='NE'][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:acceptAckCode[@code='AL' or @code='NE'][not(@nullFlavor)])&lt;=1">(QUMT_IN020011NL02): element hl7:acceptAckCode[@code='AL' or @code='NE'][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:receiver)&gt;=1">(QUMT_IN020011NL02): element hl7:receiver is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:receiver)&lt;=1">(QUMT_IN020011NL02): element hl7:receiver komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:sender[not(@nullFlavor)])&gt;=1">(QUMT_IN020011NL02): element hl7:sender[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count(hl7:sender[not(@nullFlavor)])&lt;=1">(QUMT_IN020011NL02): element hl7:sender[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <let name="transmission" value="."/>
        <let name="interactionId" value="$transmission/local-name()"/>
        <let name="interactionVocabFile" value="'../vocab/2.16.840.1.113883.1.6.xml'"/>
        <let name="interactionVocab" value="if (doc-available($interactionVocabFile)) then doc($interactionVocabFile) else ()"/>
        <let name="interactionName" value="$interactionVocab/*/hl7:code[@code=$interactionId]/@displayName"/>
        <let name="isActive" value="not(exists($interactionVocab/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='Actief'][@value='false']))"/>
        <let name="allowBsn" value="exists($interactionVocab/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='AttentionLineMetBsn'][@value='true'])"/>
        <let name="allowContextCode" value="exists($interactionVocab/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='AttentionLineMetContextCode'][@value='true'])"/>
        <let name="senderGbpOrGbk" value="exists($transmission/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:code[@codeSystem=('2.16.840.1.113883.2.4.3.11.8','2.16.840.1.113883.2.4.3.11.6')])"/>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="$interactionVocab">(QUMT_IN020011NL02): Transmission: <value-of select="$interactionVocabFile"/> niet gevonden. Controles gebaseerd op dit externe configuratiebestand zijn gedeactiveerd.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="not($interactionVocab) or $isActive">(QUMT_IN020011NL02): Transmission: deze interactie <value-of select="$interactionId"/> (<value-of select="$interactionName"/>) is niet (meer) Actief in <value-of select="$interactionVocabFile"/>
        </assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="not($interactionVocab) or not($allowBsn) or $transmission/hl7:attentionLine/hl7:keyWordText[@code=('FICID','PATID')][@codeSystem='2.16.840.1.113883.2.4.15.1']">(QUMT_IN020011NL02): Transmission: er moet in deze interactie exact één AttentionLine met BSN zitten - <value-of select="$interactionId"/> (<value-of select="$interactionName"/>)</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="not($interactionVocab) or  not($allowContextCode) or $transmission/hl7:attentionLine/hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']">(QUMT_IN020011NL02): Transmission: er moet in deze interactie exact één AttentionLine met de ContextCode zitten - <value-of select="$interactionId"/> (<value-of select="$interactionName"/>)</assert>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="not($interactionVocab) or not($transmission/hl7:attentionLine/hl7:keywordText[@code=('FICID','PATID')][@codeSystem='2.16.840.1.113883.2.4.15.1']) or $allowBsn or $senderGbpOrGbk">(QUMT_IN020011NL02): Transmission: deze interactie <value-of select="$interactionId"/> (<value-of select="$interactionName"/>) is niet geconfigureerd voor gebruik van het element <value-of select="local-name()"/> voor BSN in <value-of select="$interactionVocabFile"/> en afzender is niet GBK of GBP</assert>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="not($interactionVocab) or not($transmission/hl7:attentionLine/hl7:keywordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']) or $allowContextCode or $senderGbpOrGbk">(QUMT_IN020011NL02): Transmission: deze interactie <value-of select="$interactionId"/> (<value-of select="$interactionName"/>) is niet geconfigureerd voor gebruik van het element <value-of select="local-name()"/> voor ContextCode in <value-of select="$interactionVocabFile"/> en afzender is niet GBK of GBP</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count($transmission/hl7:attentionLine/hl7:keyWordText[@code=('FICID','PATID')][@codeSystem='2.16.840.1.113883.2.4.15.1'])&lt;=1">(QUMT_IN020011NL02): Transmission: er mag maximaal één AttentionLine met BSN zijn - <value-of select="$interactionId"/> (<value-of select="$interactionName"/>)</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.29" test="count($transmission/hl7:attentionLine/hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1'])&lt;=1">(QUMT_IN020011NL02): Transmission: er mag maximaal één AttentionLine met de ContextCode zijn - <value-of select="$interactionId"/> (<value-of select="$interactionName"/>)</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:QUMT_IN020011NL02/hl7:id[not(@nullFlavor)]
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:id[not(@nullFlavor)]" id="d885722e126-false-d885744e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="@root and @extension">(MCCI_MT000100): Transmission: id element mist root of extension</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:QUMT_IN020011NL02/hl7:creationTime[not(@nullFlavor)]
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:creationTime[not(@nullFlavor)]" id="d885722e131-false-d885757e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS.DATETIME.MIN"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="not(*)">(MCCI_MT000100): <value-of select="local-name()"/> met datatype TS.DATETIME.MIN, MAG GEEN elementen bevatten.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:QUMT_IN020011NL02/hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)]
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)]" id="d885722e136-false-d885773e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="@nullFlavor or (@code='NICTIZEd2005-Okt')">(MCCI_MT000100): de elementwaarde MOET een zijn van 'code 'NICTIZEd2005-Okt''.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:QUMT_IN020011NL02/hl7:interactionId[@root='2.16.840.1.113883.1.6']
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:interactionId[@root='2.16.840.1.113883.1.6']" id="d885722e140-false-d885792e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="string(@root)=('2.16.840.1.113883.1.6')">(MCCI_MT000100): de waarde van @root MOET '2.16.840.1.113883.1.6' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="not(@root='2.16.840.1.113883.1.6') or local-name(..)=@extension">(MCCI_MT000100): Transmission: @extension moet overeenkomen met het startelement van het bericht</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:QUMT_IN020011NL02/hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1']
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1']" id="d885722e146-false-d885809e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="string(@root)=('2.16.840.1.113883.2.4.3.11.1')">(MCCI_MT000100): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.1' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="string(@extension)=('810')">(MCCI_MT000100): de waarde van @extension MOET '810' zijn.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:QUMT_IN020011NL02/hl7:processingCode[@code='P'][not(@nullFlavor)]
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:processingCode[@code='P'][not(@nullFlavor)]" id="d885722e151-false-d885830e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="@nullFlavor or (@code='P')">(MCCI_MT000100): de elementwaarde MOET een zijn van 'code 'P''.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:QUMT_IN020011NL02/hl7:processingModeCode[@code='T'][not(@nullFlavor)]
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:processingModeCode[@code='T'][not(@nullFlavor)]" id="d885722e155-false-d885849e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="@nullFlavor or (@code='T')">(MCCI_MT000100): de elementwaarde MOET een zijn van 'code 'T''.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:QUMT_IN020011NL02/hl7:acceptAckCode[@code='AL' or @code='NE'][not(@nullFlavor)]
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:acceptAckCode[@code='AL' or @code='NE'][not(@nullFlavor)]" id="d885722e160-false-d885868e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="@nullFlavor or (@code='AL') or (@code='NE')">(MCCI_MT000100): de elementwaarde MOET een zijn van 'code 'AL' of code 'NE''.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.120
Context: /hl7:QUMT_IN020011NL02/hl7:attentionLine
Item: (TransmissionWrapperAttentionLine)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:attentionLine" id="d885869e22-false-d885890e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="count(hl7:keyWordText[not(@nullFlavor)])&gt;=1">(TransmissionWrapperAttentionLine): element hl7:keyWordText[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="count(hl7:keyWordText[not(@nullFlavor)])&lt;=1">(TransmissionWrapperAttentionLine): element hl7:keyWordText[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="count(hl7:value[not(@nullFlavor)])&gt;=1">(TransmissionWrapperAttentionLine): element hl7:value[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="count(hl7:value[not(@nullFlavor)])&lt;=1">(TransmissionWrapperAttentionLine): element hl7:value[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.120
Context: /hl7:QUMT_IN020011NL02/hl7:attentionLine/hl7:keyWordText[not(@nullFlavor)]
Item: (TransmissionWrapperAttentionLine)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:attentionLine/hl7:keyWordText[not(@nullFlavor)]" id="d885869e25-false-d885924e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='SC' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperAttentionLine): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:SC" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="SC"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.120
Context: /hl7:QUMT_IN020011NL02/hl7:attentionLine/hl7:value[not(@nullFlavor)]
Item: (TransmissionWrapperAttentionLine)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:attentionLine/hl7:value[not(@nullFlavor)]" id="d885869e34-false-d885937e0">
        <extends rule="ANY"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="@xsi:type">(TransmissionWrapperAttentionLine): attribute @xsi:type MOET aanwezig zijn.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:QUMT_IN020011NL02/hl7:receiver
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver" id="d885722e168-false-d885951e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="string(@typeCode)=('RCV') or not(@typeCode)">(MCCI_MT000100): de waarde van @typeCode MOET 'RCV' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="count(hl7:device[not(@nullFlavor)])&gt;=1">(MCCI_MT000100): element hl7:device[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="count(hl7:device[not(@nullFlavor)])&lt;=1">(MCCI_MT000100): element hl7:device[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]" id="d885958e20-false-d885980e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.6'])&gt;=1">(TransmissionWrapperDevice): element hl7:id[@root='2.16.840.1.113883.2.4.6.6'] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.6'])&lt;=1">(TransmissionWrapperDevice): element hl7:id[@root='2.16.840.1.113883.2.4.6.6'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:name)&lt;=1">(TransmissionWrapperDevice): element hl7:name komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:agencyFor)&lt;=1">(TransmissionWrapperDevice): element hl7:agencyFor komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.6']
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.6']" id="d885958e23-false-d886020e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@root)=('2.16.840.1.113883.2.4.6.6')">(TransmissionWrapperDevice): de waarde van @root MOET '2.16.840.1.113883.2.4.6.6' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="@extension">(TransmissionWrapperDevice): attribute @extension MOET aanwezig zijn.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:name
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:name" id="d885958e28-false-d886041e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='EN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:EN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="EN"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor" id="d885958e31-false-d886054e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('AGNT') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'AGNT' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:representedOrganization)&lt;=1">(TransmissionWrapperDevice): element hl7:representedOrganization komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization" id="d885958e35-false-d886076e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('ORG') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'ORG' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(TransmissionWrapperDevice): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[not(@nullFlavor)])&gt;=1">(TransmissionWrapperDevice): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[not(@nullFlavor)])&lt;=1">(TransmissionWrapperDevice): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:NotificationParty)&lt;=1">(TransmissionWrapperDevice): element hl7:NotificationParty komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:id[not(@nullFlavor)]
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:id[not(@nullFlavor)]" id="d885958e38-false-d886127e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:name
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:name" id="d885958e41-false-d886140e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:telecom
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:telecom" id="d885958e44-false-d886153e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty" id="d885958e47-false-d886167e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('CON') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'CON' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:contactParty)&gt;=1">(TransmissionWrapperDevice): element hl7:contactParty is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:contactParty)&lt;=1">(TransmissionWrapperDevice): element hl7:contactParty komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:id
Item: (COCT_MT040203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:id" id="d886173e18-false-d886216e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:code
Item: (COCT_MT040203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:code" id="d886173e19-false-d886229e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:addr
Item: (COCT_MT040203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:addr" id="d886173e20-false-d886242e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:telecom
Item: (COCT_MT040203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:telecom" id="d886173e21-false-d886255e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty
Item: (COCT_MT040203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty" id="d886173e22-false-d886268e0">
        <let name="elmcount" value="count(hl7:Organization|hl7:Person)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="$elmcount&gt;=1">(COCT_MT040203): keuze (hl7:Organization of hl7:Person) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="$elmcount&lt;=1">(COCT_MT040203): keuze (hl7:Organization of hl7:Person) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="count(hl7:Organization)&lt;=1">(COCT_MT040203): element hl7:Organization komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="count(hl7:Person)&lt;=1">(COCT_MT040203): element hl7:Person komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization
Item: (COCT_MT040203)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('ORG') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'ORG' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT150003): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:id)&gt;=1">(COCT_MT150003): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:code)&lt;=1">(COCT_MT150003): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:contact)&gt;=1">(COCT_MT150003): element hl7:contact is required [min 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:id
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:code
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:name
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:name">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('CON') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'CON' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:code)&lt;=1">(COCT_MT150003): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:contactPerson)&lt;=1">(COCT_MT150003): element hl7:contactPerson komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:id
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:code
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:addr
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:addr">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:telecom
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson">
        <extends rule="d886492e22-false-d887186e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT150003): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:name)&gt;=1">(COCT_MT150003): element hl7:name is required [min 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name">
        <extends rule="d887172e21-false-d887261e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId">
        <extends rule="d887172e31-false-d887420e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson
Item: (COCT_MT030203)
-->
    <rule id="d886492e22-false-d887186e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT030203): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT030203): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:id)&gt;=1">(COCT_MT030203): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:administrativeGenderCode)&lt;=1">(COCT_MT030203): element hl7:administrativeGenderCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:birthTime)&lt;=1">(COCT_MT030203): element hl7:birthTime komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:id
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name
Item: (COCT_MT030203)
-->
    <rule id="d887172e21-false-d887261e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:administrativeGenderCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:administrativeGenderCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:birthTime
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:birthTime">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="not(*)">(COCT_MT030203): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:languageCode)&lt;=1">(COCT_MT030203): element hl7:languageCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:modeCode)&lt;=1">(COCT_MT030203): element hl7:modeCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:proficiencyLevelCode)&lt;=1">(COCT_MT030203): element hl7:proficiencyLevelCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:preferenceInd)&lt;=1">(COCT_MT030203): element hl7:preferenceInd komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:languageCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:languageCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:modeCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:modeCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:proficiencyLevelCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:proficiencyLevelCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:preferenceInd
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:preferenceInd">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="BL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule id="d887172e31-false-d887420e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person
Item: (COCT_MT040203)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT030203): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT030203): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:id)&gt;=1">(COCT_MT030203): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:administrativeGenderCode)&lt;=1">(COCT_MT030203): element hl7:administrativeGenderCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:birthTime)&lt;=1">(COCT_MT030203): element hl7:birthTime komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:id
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:name
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:name">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:administrativeGenderCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:administrativeGenderCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:birthTime
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:birthTime">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="not(*)">(COCT_MT030203): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:languageCode)&lt;=1">(COCT_MT030203): element hl7:languageCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:modeCode)&lt;=1">(COCT_MT030203): element hl7:modeCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:proficiencyLevelCode)&lt;=1">(COCT_MT030203): element hl7:proficiencyLevelCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:preferenceInd)&lt;=1">(COCT_MT030203): element hl7:preferenceInd komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:languageCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:languageCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:modeCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:modeCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:proficiencyLevelCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:proficiencyLevelCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:preferenceInd
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:preferenceInd">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="BL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:QUMT_IN020011NL02/hl7:respondTo
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:respondTo" id="d885722e171-false-d887766e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="string(@typeCode)=('RSP') or not(@typeCode)">(MCCI_MT000100): de waarde van @typeCode MOET 'RSP' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="count(hl7:entityRsp[not(@nullFlavor)])&gt;=1">(MCCI_MT000100): element hl7:entityRsp[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="count(hl7:entityRsp[not(@nullFlavor)])&lt;=1">(MCCI_MT000100): element hl7:entityRsp[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:QUMT_IN020011NL02/hl7:respondTo/hl7:telecom
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:respondTo/hl7:telecom" id="d885722e173-false-d887797e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:QUMT_IN020011NL02/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]" id="d885722e174-false-d887810e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="not(@classCode) or (string-length(@classCode)&gt;0 and not(matches(@classCode,'\s')))">(MCCI_MT000100): attribuut @classCode MOET datatype 'cs' hebben</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@classCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.10882-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="not(@classCode) or count($theAttValue) = count($theAttCheck)">(MCCI_MT000100): de waarde van classCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.10882' EntityClass (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="not(@determinerCode) or (string-length(@determinerCode)&gt;0 and not(matches(@determinerCode,'\s')))">(MCCI_MT000100): attribuut @determinerCode MOET datatype 'cs' hebben</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@determinerCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.10878-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="not(@determinerCode) or count($theAttValue) = count($theAttCheck)">(MCCI_MT000100): de waarde van determinerCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.10878' EntityDeterminer (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="count(hl7:id[not(@nullFlavor)])&gt;=1">(MCCI_MT000100): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:QUMT_IN020011NL02/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]" id="d885722e179-false-d887870e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:QUMT_IN020011NL02/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:name
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:name" id="d885722e180-false-d887883e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='EN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:EN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="EN"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:QUMT_IN020011NL02/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:telecom
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:telecom" id="d885722e181-false-d887896e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]" id="d885722e182-false-d887910e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="string(@typeCode)=('SND') or not(@typeCode)">(MCCI_MT000100): de waarde van @typeCode MOET 'SND' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="count(hl7:device[not(@nullFlavor)])&gt;=1">(MCCI_MT000100): element hl7:device[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="count(hl7:device[not(@nullFlavor)])&lt;=1">(MCCI_MT000100): element hl7:device[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]" id="d887917e20-false-d887939e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.6'])&gt;=1">(TransmissionWrapperDevice): element hl7:id[@root='2.16.840.1.113883.2.4.6.6'] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.6'])&lt;=1">(TransmissionWrapperDevice): element hl7:id[@root='2.16.840.1.113883.2.4.6.6'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:name)&lt;=1">(TransmissionWrapperDevice): element hl7:name komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:agencyFor)&lt;=1">(TransmissionWrapperDevice): element hl7:agencyFor komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.6']
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.6']" id="d887917e23-false-d887979e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@root)=('2.16.840.1.113883.2.4.6.6')">(TransmissionWrapperDevice): de waarde van @root MOET '2.16.840.1.113883.2.4.6.6' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="@extension">(TransmissionWrapperDevice): attribute @extension MOET aanwezig zijn.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:name
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:name" id="d887917e28-false-d888000e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='EN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:EN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="EN"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor" id="d887917e31-false-d888013e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('AGNT') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'AGNT' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:representedOrganization)&lt;=1">(TransmissionWrapperDevice): element hl7:representedOrganization komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization" id="d887917e35-false-d888035e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('ORG') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'ORG' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(TransmissionWrapperDevice): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[not(@nullFlavor)])&gt;=1">(TransmissionWrapperDevice): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[not(@nullFlavor)])&lt;=1">(TransmissionWrapperDevice): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:NotificationParty)&lt;=1">(TransmissionWrapperDevice): element hl7:NotificationParty komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:id[not(@nullFlavor)]
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:id[not(@nullFlavor)]" id="d887917e38-false-d888086e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:name
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:name" id="d887917e41-false-d888099e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:telecom
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:telecom" id="d887917e44-false-d888112e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty" id="d887917e47-false-d888126e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('CON') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'CON' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:contactParty)&gt;=1">(TransmissionWrapperDevice): element hl7:contactParty is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:contactParty)&lt;=1">(TransmissionWrapperDevice): element hl7:contactParty komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:id
Item: (COCT_MT040203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:id" id="d888132e18-false-d888175e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:code
Item: (COCT_MT040203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:code" id="d888132e19-false-d888188e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:addr
Item: (COCT_MT040203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:addr" id="d888132e20-false-d888201e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:telecom
Item: (COCT_MT040203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:telecom" id="d888132e21-false-d888214e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty
Item: (COCT_MT040203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty" id="d888132e22-false-d888227e0">
        <let name="elmcount" value="count(hl7:Organization|hl7:Person)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="$elmcount&gt;=1">(COCT_MT040203): keuze (hl7:Organization of hl7:Person) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="$elmcount&lt;=1">(COCT_MT040203): keuze (hl7:Organization of hl7:Person) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="count(hl7:Organization)&lt;=1">(COCT_MT040203): element hl7:Organization komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="count(hl7:Person)&lt;=1">(COCT_MT040203): element hl7:Person komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization
Item: (COCT_MT040203)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('ORG') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'ORG' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT150003): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:id)&gt;=1">(COCT_MT150003): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:code)&lt;=1">(COCT_MT150003): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:contact)&gt;=1">(COCT_MT150003): element hl7:contact is required [min 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:id
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:code
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:name
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:name">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('CON') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'CON' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:code)&lt;=1">(COCT_MT150003): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:contactPerson)&lt;=1">(COCT_MT150003): element hl7:contactPerson komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:id
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:code
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:addr
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:addr">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:telecom
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson">
        <extends rule="d888451e22-false-d889145e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT150003): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:name)&gt;=1">(COCT_MT150003): element hl7:name is required [min 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name">
        <extends rule="d889131e21-false-d889220e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId">
        <extends rule="d889131e31-false-d889379e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson
Item: (COCT_MT030203)
-->
    <rule id="d888451e22-false-d889145e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT030203): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT030203): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:id)&gt;=1">(COCT_MT030203): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:administrativeGenderCode)&lt;=1">(COCT_MT030203): element hl7:administrativeGenderCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:birthTime)&lt;=1">(COCT_MT030203): element hl7:birthTime komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:id
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name
Item: (COCT_MT030203)
-->
    <rule id="d889131e21-false-d889220e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:administrativeGenderCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:administrativeGenderCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:birthTime
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:birthTime">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="not(*)">(COCT_MT030203): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:languageCode)&lt;=1">(COCT_MT030203): element hl7:languageCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:modeCode)&lt;=1">(COCT_MT030203): element hl7:modeCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:proficiencyLevelCode)&lt;=1">(COCT_MT030203): element hl7:proficiencyLevelCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:preferenceInd)&lt;=1">(COCT_MT030203): element hl7:preferenceInd komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:languageCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:languageCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:modeCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:modeCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:proficiencyLevelCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:proficiencyLevelCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:preferenceInd
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:preferenceInd">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="BL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule id="d889131e31-false-d889379e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person
Item: (COCT_MT040203)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT030203): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT030203): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:id)&gt;=1">(COCT_MT030203): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:administrativeGenderCode)&lt;=1">(COCT_MT030203): element hl7:administrativeGenderCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:birthTime)&lt;=1">(COCT_MT030203): element hl7:birthTime komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:id
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:name
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:name">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:administrativeGenderCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:administrativeGenderCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:birthTime
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:birthTime">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="not(*)">(COCT_MT030203): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:languageCode)&lt;=1">(COCT_MT030203): element hl7:languageCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:modeCode)&lt;=1">(COCT_MT030203): element hl7:modeCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:proficiencyLevelCode)&lt;=1">(COCT_MT030203): element hl7:proficiencyLevelCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:preferenceInd)&lt;=1">(COCT_MT030203): element hl7:preferenceInd komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:languageCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:languageCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:modeCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:modeCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:proficiencyLevelCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:proficiencyLevelCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:preferenceInd
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:preferenceInd">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="BL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.5
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess
Item: (QUQI_MT021001)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess" id="d889718e20-false-d889730e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="string(@moodCode)=('EVN')">(QUQI_MT021001): de waarde van @moodCode MOET 'EVN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not(@moodCode) or (string-length(@moodCode)&gt;0 and not(matches(@moodCode,'\s')))">(QUQI_MT021001): attribuut @moodCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="count(hl7:code)&lt;=1">(QUQI_MT021001): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="count(hl7:effectiveTime)&lt;=1">(QUQI_MT021001): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="count(hl7:authorOrPerformer[not(@nullFlavor)])&gt;=1">(QUQI_MT021001): element hl7:authorOrPerformer[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="count(hl7:authorOrPerformer[not(@nullFlavor)])&lt;=1">(QUQI_MT021001): element hl7:authorOrPerformer[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="count(hl7:overseer)&lt;=1">(QUQI_MT021001): element hl7:overseer komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="count(hl7:queryByParameter[not(@nullFlavor)])&gt;=1">(QUQI_MT021001): element hl7:queryByParameter[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="count(hl7:queryByParameter[not(@nullFlavor)])&lt;=1">(QUQI_MT021001): element hl7:queryByParameter[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <let name="controlActProcess" value="."/>
        <let name="authorEntity" value="$controlActProcess/hl7:authorOrPerformer//hl7:*[lower-case(local-name())=('assigneddevice','assignedperson')][1]"/>
        <let name="authorDevice" value="$authorEntity[lower-case(local-name())='assigneddevice']"/>
        <let name="authorPerson" value="$authorEntity[lower-case(local-name())='assignedperson']"/>
        <let name="overseerPerson" value="$controlActProcess/hl7:overseer//hl7:*[lower-case(local-name())=('assignedentity','assignedperson')][1]"/>
        <let name="authorPath" value="string-join($authorEntity/ancestor-or-self::*/name(),'/')"/>
        <let name="overseerPath" value="string-join($overseerPerson/ancestor-or-self::*/name(),'/')"/>
        <let name="senderApplicationId" value="$controlActProcess/../hl7:sender/hl7:device/hl7:id[@root='2.16.840.1.113883.2.4.6.6']/@extension"/>
        <let name="authorApplicationId" value="$authorDevice/hl7:id[@root='2.16.840.1.113883.2.4.6.6']/@extension"/>
        <let name="overseerOrgId" value="$overseerPerson/hl7:Organization/hl7:id"/>
        <let name="authorOrgId" value="$authorEntity/hl7:Organization/hl7:id"/>
        <let name="interactionId" value="$controlActProcess/../local-name()"/>
        <let name="interactionVocabFile" value="'../vocab/2.16.840.1.113883.1.6.xml'"/>
        <let name="interactionVocab" value="if (doc-available($interactionVocabFile)) then doc($interactionVocabFile) else ()"/>
        <let name="interactionTrustLevel" value="$interactionVocab/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='Vertrouwensniveau']/@value"/>
        <let name="interactionSendType" value="$interactionVocab/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='Verzendtype']/@value"/>
        <let name="interactionTriggerEventCode" value="$interactionVocab/*/hl7:code[@code=$interactionId]/hl7:reference/@extension"/>
        <let name="messageTriggerEventCode" value="$controlActProcess/hl7:code/@code"/>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="$interactionVocab">(QUQI_MT021001): Control Act: <value-of select="$interactionVocabFile"/> niet gevonden. Controles gebaseerd op dit externe configuratiebestand zijn gedeactiveerd.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($controlActProcess/hl7:queryByParameter) or $controlActProcess[@moodCode='EVN']">(QUQI_MT021001): Control Act: <value-of select="local-name()"/>/@moodCode moet 'EVN' zijn bij queries</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($interactionVocab) or not($messageTriggerEventCode) or $interactionTriggerEventCode=$messageTriggerEventCode">(QUQI_MT021001): Control Act: <value-of select="local-name()"/>/code (Trigger Event) moet bij deze interactie '<value-of select="$interactionTriggerEventCode"/>' zijn, gevonden is echter '<value-of select="$messageTriggerEventCode"/>'</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($interactionVocab) or $authorPerson or not($interactionTrustLevel) or $interactionTrustLevel='Laag'">(QUQI_MT021001): Control Act: <value-of select="local-name()"/>/authorOrPerformer moet een persoon bevatten in berichten met vertrouwensniveau midden of hoog</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($interactionVocab) or $overseerPerson or empty($interactionTrustLevel) or $interactionTrustLevel='Laag'">(QUQI_MT021001): Control Act: <value-of select="local-name()"/>/overseer moet de mandaterende persoon bevatten in berichten met vertrouwensniveau midden of hoog</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($authorEntity//hl7:id[@root='2.16.840.1.113883.2.4.6.3']) or not($authorEntity/../(hl7:queryByParameter|hl7:subject)//hl7:*[@root='2.16.840.1.113883.2.4.6.3']) or $authorEntity/../../hl7:attentionLine">(QUQI_MT021001): Patiëntgebonden interacties, verzonden vanuit een patiëntenportaal (GBP), moeten een attentionLine hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($authorEntity//hl7:id[@root=('2.16.840.1.113883.2.4.3.11.7.3','2.16.528.1.1003.1.3.5.4.1')]) or not($authorEntity/../(hl7:queryByParameter|hl7:subject)//hl7:*[@root='2.16.840.1.113883.2.4.6.3']) or $authorEntity/../../hl7:attentionLine">(QUQI_MT021001): Patiëntgebonden interacties, verzonden vanuit het klantenloket (GBK), moeten een attentionLine hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="empty($senderApplicationId) or empty($authorApplicationId) or $senderApplicationId=$authorApplicationId or $senderApplicationId='1'">(QUQI_MT021001): Control Act: <value-of select="$authorPath"/>/id. Applicatie-id <value-of select="$authorApplicationId"/> komt niet overeen met Transmission-wrapper sender <value-of select="$senderApplicationId"/>.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($authorDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3']) or $authorDevice/hl7:id[@root='2.16.528.1.1007.3.2']">(QUQI_MT021001): Control Act: <value-of select="$authorPath"/>/id moet tenminste het UZI-nummer systemen bevatten voor een XIS in een GBZ</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($authorDevice/hl7:id[@root='2.16.528.1.1007.3.2']) or $authorDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3' and @extension]">(QUQI_MT021001): Control Act: <value-of select="$authorPath"/>/id moet de zorgaanbieder van het XIS identificeren</assert>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($authorDevice) or $authorDevice/hl7:id[@root='2.16.840.1.113883.2.4.6.6'][@extension='1'] or $authorDevice/hl7:id[@root='2.16.528.1.1007.4'] or $authorDevice/hl7:Organization/hl7:id">(QUQI_MT021001): Control Act: <value-of select="$authorPath"/>/ moet een geïdentificeerde organisatie hebben, tenzij het de ZIM of het SBV-Z betreft.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($authorPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.3']) or $authorPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'][@code='P']">(QUQI_MT021001): Control Act: <value-of select="$authorPath"/>/code/@code moet "P" (Patiënt) zijn. Wettelijke vertegenwoordigers moet dit via het Klantenloket doen en kunnen dus niet als auteur optreden</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($authorPerson/hl7:id[@root=('2.16.840.1.113883.2.4.3.11.7.3','2.16.528.1.1003.1.3.5.4.1')]) or $authorPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'][@code='KLANTENLOKET']">(QUQI_MT021001): Control Act: <value-of select="$authorPath"/>/code/@code moet "KLANTENLOKET" zijn voor klantenloketmedewerkers</assert>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($authorPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $authorPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']">(QUQI_MT021001): Control Act: <value-of select="$authorPath"/>/code ontbreekt. Dit is alleen toegestaan als de rolcode 00.000 is.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($authorPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $authorOrgId[@root='2.16.528.1.1007.3.3' and @extension]">(QUQI_MT021001): Control Act: <value-of select="$authorPath"/>/Organization/id moet de zorgaanbieder van de persoon identificeren</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($authorPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.3']) or $authorOrgId[@root='2.16.840.1.113883.2.4.3.11.25']">(QUQI_MT021001): Control Act: <value-of select="$authorPath"/>/Organization/id/@root moet '2.16.840.1.113883.2.4.3.11.25' bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($authorPerson/hl7:id[@root=('2.16.840.1.113883.2.4.3.11','2.16.528.1.1003.1.3.5.4.1')]) or $authorOrgId[@root='2.16.840.1.113883.2.4.3.11'][@extension='7']">(QUQI_MT021001): Control Act: <value-of select="$authorPath"/>/Organization/id moet de Nictiz-klantenloket organisatie identificeren</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($overseerPerson/hl7:Organization[not(hl7:name)]/hl7:id[@root='2.16.528.1.1007.3.3'])">(QUQI_MT021001): Control Act: <value-of select="$authorPath"/>/Organization/name moet de zorgaanbieder/organisatienaam bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($overseerPerson/hl7:Organization[not(hl7:name)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11' and @extension='7'])">(QUQI_MT021001): Control Act: <value-of select="$authorPath"/>/Organization/name moet de Nictiz-klantenloket organisatienaam bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($overseerPerson) or $overseerPerson/hl7:code">(QUQI_MT021001): Control Act: <value-of select="$overseerPath"/>/code is verplicht</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($overseerPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.3']) or $overseerPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'][@code='P'] or $overseerPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.6']">(QUQI_MT021001): Control Act: <value-of select="$overseerPath"/>/code/@code moet "P" (Patiënt) zijn of een geldige waarde uit RoleCodeWettelijkeVertegenwoordigerNL</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($overseerPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $overseerPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson/hl7:name">(QUQI_MT021001): Control Act: <value-of select="$overseerPath"/>/assignedPrincipalChoiceList/assignedPerson/name is verplicht</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($overseerPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $overseerPerson/hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3']">(QUQI_MT021001): Control Act: <value-of select="$overseerPath"/>/Organization/id moet de zorgaanbieder van de persoon identificeren</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($overseerPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $overseerPerson/hl7:Organization/hl7:name">(QUQI_MT021001): Control Act: <value-of select="$overseerPath"/>//Organization/name moet de zorgaanbiedernaam bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($overseerPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $overseerPerson/hl7:Organization/hl7:addr/hl7:city">(QUQI_MT021001): Control Act: <value-of select="$overseerPath"/>/Organization/addr moet tennminste de vestigingsplaats bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not($overseerOrgId) or $authorOrgId[@root=$overseerOrgId/@root][@extension=$overseerOrgId/@extension] or $authorEntity[lower-case(local-name())='assigneddevice']">(QUQI_MT021001): Control Act: <value-of select="$overseerPath"/>/Organization/id. Organisatie van de overseer (<value-of select="$overseerOrgId/@root"/>#<value-of select="$overseerOrgId/@extension"/>) moet gelijk zijn aan die van de authorOrPerformer (<value-of select="$authorOrgId/@extension"/>)</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.5
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:code
Item: (QUQI_MT021001)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:code" id="d889718e22-false-d889815e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QUQI_MT021001): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="@nullFlavor or (@codeSystem='2.16.840.1.113883.1.18')">(QUQI_MT021001): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.1.18''.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.5
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:effectiveTime
Item: (QUQI_MT021001)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:effectiveTime" id="d889718e26-false-d889834e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QUQI_MT021001): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.5" test="not(*)">(QUQI_MT021001): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.500
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer
Item: (ControlActAuthorOrPerformer)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer" id="d889835e57-false-d889850e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="@typeCode">(ControlActAuthorOrPerformer): attribute @typeCode MOET aanwezig zijn.</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@typeCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.19080-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="not(@typeCode) or count($theAttValue) = count($theAttCheck)">(ControlActAuthorOrPerformer): de waarde van typeCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.19080' x_ParticipationAuthorPerformer (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="count(hl7:participant[not(@nullFlavor)])&gt;=1">(ControlActAuthorOrPerformer): element hl7:participant[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="count(hl7:participant[not(@nullFlavor)])&lt;=1">(ControlActAuthorOrPerformer): element hl7:participant[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.500
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]
Item: (ControlActAuthorOrPerformer)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]" id="d889835e64-false-d889886e0">
        <let name="elmcount" value="count(hl7:AssignedDevice|hl7:AssignedPerson)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="$elmcount&gt;=1">(ControlActAuthorOrPerformer): keuze (hl7:AssignedDevice of hl7:AssignedPerson) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="$elmcount&lt;=1">(ControlActAuthorOrPerformer): keuze (hl7:AssignedDevice of hl7:AssignedPerson) bevat te veel elementen [max 1x]</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.500
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice
Item: (ControlActAuthorOrPerformer)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice
Item: (COCT_MT090300)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.2']|hl7:id[@root='2.16.840.1.113883.2.4.6.6']|hl7:id[@root='2.16.528.1.1007.4'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="$elmcount&gt;=1">(COCT_MT090300): keuze (hl7:id[@root='2.16.528.1.1007.3.2'] of hl7:id[@root='2.16.840.1.113883.2.4.6.6'] of hl7:id[@root='2.16.528.1.1007.4']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="$elmcount&lt;=2">(COCT_MT090300): keuze (hl7:id[@root='2.16.528.1.1007.3.2'] of hl7:id[@root='2.16.840.1.113883.2.4.6.6'] of hl7:id[@root='2.16.528.1.1007.4']) bevat te veel elementen [max 2x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:Organization)&lt;=1">(COCT_MT090300): element hl7:Organization komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1010
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.528.1.1007.3.2']
Item: (dtUZIsystemen)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.528.1.1007.3.2']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1010" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtUZIsystemen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.UZI"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1010" test="string(@root)=('2.16.528.1.1007.3.2')">(dtUZIsystemen): de waarde van @root MOET '2.16.528.1.1007.3.2' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1008
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.840.1.113883.2.4.6.6']
Item: (dtAortaApplicationId)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.840.1.113883.2.4.6.6']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1008" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtAortaApplicationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1008" test="string(@root)=('2.16.840.1.113883.2.4.6.6')">(dtAortaApplicationId): de waarde van @root MOET '2.16.840.1.113883.2.4.6.6' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1018
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.528.1.1007.4']
Item: (dtSBV-Zsystemen)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.528.1.1007.4']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1018" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtSBV-Zsystemen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1018" test="string(@root)=('2.16.528.1.1007.4')">(dtSBV-Zsystemen): de waarde van @root MOET '2.16.528.1.1007.4' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization
Item: (COCT_MT090300)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id[@root='2.16.528.1.1007']|hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']|hl7:id[@root='2.16.840.1.113883.2.4.3.11'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="$elmcount&gt;=1">(COCT_MT090300): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="$elmcount&lt;=1">(COCT_MT090300): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:code)&lt;=1">(COCT_MT090300): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:name[not(@nullFlavor)])&gt;=1">(COCT_MT090300): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:name[not(@nullFlavor)])&lt;=1">(COCT_MT090300): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:addr)&lt;=1">(COCT_MT090300): element hl7:addr komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1011
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (dtURAorganization)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtURAorganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.URA"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="string(@root)=('2.16.528.1.1007.3.3')">(dtURAorganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1019
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007']
Item: (dtSBV-ZOrganizationId)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtSBV-ZOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@root)=('2.16.528.1.1007')">(dtSBV-ZOrganizationId): de waarde van @root MOET '2.16.528.1.1007' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@extension)=('4')">(dtSBV-ZOrganizationId): de waarde van @extension MOET '4' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1020
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']
Item: (dtGBO-GBP)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBO-GBP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="string(@root)=('2.16.840.1.113883.2.4.3.11.25')">(dtGBO-GBP): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.25' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1021
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11']
Item: (dtGBKOrganizationId)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBKOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@root)=('2.16.840.1.113883.2.4.3.11')">(dtGBKOrganizationId): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@extension)=('7')">(dtGBKOrganizationId): de waarde van @extension MOET '7' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id
Item: (COCT_MT090300)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:code
Item: (COCT_MT090300)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(COCT_MT090300): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.1 RoleCodeNL - zorgaanbiedertype (organisaties) (DYNAMISCH)'.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:telecom
Item: (COCT_MT090300)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:name[not(@nullFlavor)]
Item: (COCT_MT090300)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:name[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:addr
Item: (COCT_MT090300)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:addr">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:city[not(@nullFlavor)])&gt;=1">(COCT_MT090300): element hl7:city[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:city[not(@nullFlavor)])&lt;=1">(COCT_MT090300): element hl7:city[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:addr/hl7:city[not(@nullFlavor)]
Item: (COCT_MT090300)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:templateId
Item: (COCT_MT090300)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.500
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson
Item: (ControlActAuthorOrPerformer)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.1']|hl7:id[@root='2.16.840.1.113883.2.4.6.3']|hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']|hl7:id[@root='2.16.528.1.1003.1.3.5.4.1'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&gt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id[@root='2.16.840.1.113883.2.4.6.3'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3'] of hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&lt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id[@root='2.16.840.1.113883.2.4.6.3'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3'] of hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.1'])&lt;=1">(COCT_MT090100): element hl7:id[@root='2.16.840.1.113883.2.4.6.1'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:code)&lt;=1">(COCT_MT090100): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:telecom)&lt;=1">(COCT_MT090100): element hl7:telecom komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPrincipalChoiceList)&lt;=1">(COCT_MT090100): element hl7:assignedPrincipalChoiceList komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:Organization[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:Organization[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:Organization[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:Organization[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1009
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.528.1.1007.3.1']
Item: (dtUZIpersonen)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.528.1.1007.3.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1009" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtUZIpersonen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.UZI"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1009" test="string(@root)=('2.16.528.1.1007.3.1')">(dtUZIpersonen): de waarde van @root MOET '2.16.528.1.1007.3.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1012
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.3']
Item: (dtBSN)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtBSN): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.BSN"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="string(@root)=('2.16.840.1.113883.2.4.6.3')">(dtBSN): de waarde van @root MOET '2.16.840.1.113883.2.4.6.3' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$')">(dtBSN): attribuut @root MOET datatype 'oid' hebben</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1015
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']
Item: (dtBatchInzageAuteur)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1015" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtBatchInzageAuteur): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1015" test="string(@root)=('2.16.840.1.113883.2.4.3.11.7.3')">(dtBatchInzageAuteur): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.7.3' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1016
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']
Item: (dtNictizKlantenloketPKIO)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1016" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtNictizKlantenloketPKIO): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1016" test="string(@root)=('2.16.528.1.1003.1.3.5.4.1')">(dtNictizKlantenloketPKIO): de waarde van @root MOET '2.16.528.1.1003.1.3.5.4.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1017
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.1']
Item: (dtAGB)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1017" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtAGB): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.AGB"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1017" test="string(@root)=('2.16.840.1.113883.2.4.6.1')">(dtAGB): de waarde van @root MOET '2.16.840.1.113883.2.4.6.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:code
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.4-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.5-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(COCT_MT090100): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.2 RoleCodeNL - zorgverlenertype (personen) (DYNAMISCH) of 2.16.840.1.113883.2.4.3.11.60.102.11.4 RoleCodeNL - toegang patiënt (DYNAMISCH) of 2.16.840.1.113883.2.4.3.11.60.102.11.5 RoleCodeNL - wettelijke vertegenwoording (DYNAMISCH)'.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="not(@code='00.000' and @codeSystem='2.16.840.1.113883.2.4.15.111')">(COCT_MT090100): Control Act: <name path=".."/>/<name/> moet een UZI-rolcode 00.000 is niet toegestaan</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:telecom
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPerson[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:assignedPerson[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPerson[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:assignedPerson[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id[@root='2.16.528.1.1007']|hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']|hl7:id[@root='2.16.840.1.113883.2.4.3.11'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&gt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&lt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:code)&lt;=1">(COCT_MT090100): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:addr)&lt;=1">(COCT_MT090100): element hl7:addr komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1011
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (dtURAorganization)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007.3.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtURAorganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.URA"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="string(@root)=('2.16.528.1.1007.3.3')">(dtURAorganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1019
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007']
Item: (dtSBV-ZOrganizationId)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtSBV-ZOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@root)=('2.16.528.1.1007')">(dtSBV-ZOrganizationId): de waarde van @root MOET '2.16.528.1.1007' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@extension)=('4')">(dtSBV-ZOrganizationId): de waarde van @extension MOET '4' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1020
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']
Item: (dtGBO-GBP)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBO-GBP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="string(@root)=('2.16.840.1.113883.2.4.3.11.25')">(dtGBO-GBP): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.25' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1021
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11']
Item: (dtGBKOrganizationId)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBKOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@root)=('2.16.840.1.113883.2.4.3.11')">(dtGBKOrganizationId): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@extension)=('7')">(dtGBKOrganizationId): de waarde van @extension MOET '7' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:code
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(COCT_MT090100): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.1 RoleCodeNL - zorgaanbiedertype (organisaties) (DYNAMISCH)'.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:telecom
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:addr
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:addr">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:city)&lt;=1">(COCT_MT090100): element hl7:city komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:addr/hl7:city
Item: (COCT_MT090100)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:templateId
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.503
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer
Item: (ControlActOverseerPersonQuery)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer" id="d890978e42-false-d890991e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.503" test="string(@typeCode)=('RESP')">(ControlActOverseerPersonQuery): de waarde van @typeCode MOET 'RESP' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.503
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]
Item: (ControlActOverseerPersonQuery)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.1']|hl7:id[@root='2.16.840.1.113883.2.4.6.3']|hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']|hl7:id[@root='2.16.528.1.1003.1.3.5.4.1'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&gt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id[@root='2.16.840.1.113883.2.4.6.3'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3'] of hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&lt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id[@root='2.16.840.1.113883.2.4.6.3'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3'] of hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.1'])&lt;=1">(COCT_MT090100): element hl7:id[@root='2.16.840.1.113883.2.4.6.1'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:code)&lt;=1">(COCT_MT090100): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:telecom)&lt;=1">(COCT_MT090100): element hl7:telecom komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPrincipalChoiceList)&lt;=1">(COCT_MT090100): element hl7:assignedPrincipalChoiceList komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:Organization[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:Organization[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:Organization[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:Organization[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1009
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007.3.1']
Item: (dtUZIpersonen)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007.3.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1009" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtUZIpersonen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.UZI"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1009" test="string(@root)=('2.16.528.1.1007.3.1')">(dtUZIpersonen): de waarde van @root MOET '2.16.528.1.1007.3.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1012
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.3']
Item: (dtBSN)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtBSN): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.BSN"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="string(@root)=('2.16.840.1.113883.2.4.6.3')">(dtBSN): de waarde van @root MOET '2.16.840.1.113883.2.4.6.3' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$')">(dtBSN): attribuut @root MOET datatype 'oid' hebben</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1015
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']
Item: (dtBatchInzageAuteur)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1015" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtBatchInzageAuteur): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1015" test="string(@root)=('2.16.840.1.113883.2.4.3.11.7.3')">(dtBatchInzageAuteur): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.7.3' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1016
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']
Item: (dtNictizKlantenloketPKIO)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1016" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtNictizKlantenloketPKIO): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1016" test="string(@root)=('2.16.528.1.1003.1.3.5.4.1')">(dtNictizKlantenloketPKIO): de waarde van @root MOET '2.16.528.1.1003.1.3.5.4.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1017
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.1']
Item: (dtAGB)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1017" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtAGB): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.AGB"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1017" test="string(@root)=('2.16.840.1.113883.2.4.6.1')">(dtAGB): de waarde van @root MOET '2.16.840.1.113883.2.4.6.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:code
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.4-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.5-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(COCT_MT090100): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.2 RoleCodeNL - zorgverlenertype (personen) (DYNAMISCH) of 2.16.840.1.113883.2.4.3.11.60.102.11.4 RoleCodeNL - toegang patiënt (DYNAMISCH) of 2.16.840.1.113883.2.4.3.11.60.102.11.5 RoleCodeNL - wettelijke vertegenwoording (DYNAMISCH)'.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="not(@code='00.000' and @codeSystem='2.16.840.1.113883.2.4.15.111')">(COCT_MT090100): Control Act: <name path=".."/>/<name/> moet een UZI-rolcode 00.000 is niet toegestaan</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:telecom
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:assignedPrincipalChoiceList
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:assignedPrincipalChoiceList">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPerson[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:assignedPerson[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPerson[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:assignedPerson[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id[@root='2.16.528.1.1007']|hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']|hl7:id[@root='2.16.840.1.113883.2.4.3.11'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&gt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&lt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:code)&lt;=1">(COCT_MT090100): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:addr)&lt;=1">(COCT_MT090100): element hl7:addr komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1011
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (dtURAorganization)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007.3.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtURAorganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.URA"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="string(@root)=('2.16.528.1.1007.3.3')">(dtURAorganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1019
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007']
Item: (dtSBV-ZOrganizationId)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtSBV-ZOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@root)=('2.16.528.1.1007')">(dtSBV-ZOrganizationId): de waarde van @root MOET '2.16.528.1.1007' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@extension)=('4')">(dtSBV-ZOrganizationId): de waarde van @extension MOET '4' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1020
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']
Item: (dtGBO-GBP)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBO-GBP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="string(@root)=('2.16.840.1.113883.2.4.3.11.25')">(dtGBO-GBP): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.25' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1021
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11']
Item: (dtGBKOrganizationId)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBKOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@root)=('2.16.840.1.113883.2.4.3.11')">(dtGBKOrganizationId): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@extension)=('7')">(dtGBKOrganizationId): de waarde van @extension MOET '7' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:code
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(COCT_MT090100): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.1 RoleCodeNL - zorgaanbiedertype (organisaties) (DYNAMISCH)'.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:telecom
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:addr
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:addr">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:city)&lt;=1">(COCT_MT090100): element hl7:city komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:addr/hl7:city
Item: (COCT_MT090100)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:templateId
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:overseer/hl7:assignedEntity[not(@nullFlavor)]/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.6
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter
Item: (QueryByParameter-QUMT_IN020011NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter" id="d891642e66-false-d891656e0">
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="not(.//hl7:semanticsText)">(QueryByParameter-QUMT_IN020011NL02): Control Act: het element semanticsText onder queryparameters bij voorkeur niet gebruiken</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="not(hl7:sortControl)">(QueryByParameter-QUMT_IN020011NL02): Control Act: queryByParameter/sortControl mag niet gebruikt worden</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="count(hl7:queryId[not(@nullFlavor)])&gt;=1">(QueryByParameter-QUMT_IN020011NL02): element hl7:queryId[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="count(hl7:queryId[not(@nullFlavor)])&lt;=1">(QueryByParameter-QUMT_IN020011NL02): element hl7:queryId[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="count(hl7:statusCode[@code=doc('include/voc-2.16.840.1.113883.1.11.18899-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)])&gt;=1">(QueryByParameter-QUMT_IN020011NL02): element hl7:statusCode[@code=doc('include/voc-2.16.840.1.113883.1.11.18899-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="count(hl7:statusCode[@code=doc('include/voc-2.16.840.1.113883.1.11.18899-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)])&lt;=1">(QueryByParameter-QUMT_IN020011NL02): element hl7:statusCode[@code=doc('include/voc-2.16.840.1.113883.1.11.18899-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="count(hl7:modifyCode)&lt;=1">(QueryByParameter-QUMT_IN020011NL02): element hl7:modifyCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="count(hl7:responseModalityCode[@code=doc('include/voc-2.16.840.1.113883.1.11.394-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)])&gt;=1">(QueryByParameter-QUMT_IN020011NL02): element hl7:responseModalityCode[@code=doc('include/voc-2.16.840.1.113883.1.11.394-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="count(hl7:responseModalityCode[@code=doc('include/voc-2.16.840.1.113883.1.11.394-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)])&lt;=1">(QueryByParameter-QUMT_IN020011NL02): element hl7:responseModalityCode[@code=doc('include/voc-2.16.840.1.113883.1.11.394-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="count(hl7:responsePriorityCode[@code=doc('include/voc-2.16.840.1.113883.1.11.91-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)])&gt;=1">(QueryByParameter-QUMT_IN020011NL02): element hl7:responsePriorityCode[@code=doc('include/voc-2.16.840.1.113883.1.11.91-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="count(hl7:responsePriorityCode[@code=doc('include/voc-2.16.840.1.113883.1.11.91-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)])&lt;=1">(QueryByParameter-QUMT_IN020011NL02): element hl7:responsePriorityCode[@code=doc('include/voc-2.16.840.1.113883.1.11.91-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="count(hl7:initialQuantity)&lt;=1">(QueryByParameter-QUMT_IN020011NL02): element hl7:initialQuantity komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="count(hl7:initialQuantityCode)&lt;=1">(QueryByParameter-QUMT_IN020011NL02): element hl7:initialQuantityCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="count(hl7:executionAndDeliveryTime)&lt;=1">(QueryByParameter-QUMT_IN020011NL02): element hl7:executionAndDeliveryTime komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="count(hl7:applicationId)&lt;=1">(QueryByParameter-QUMT_IN020011NL02): element hl7:applicationId komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="count(hl7:custodianOrganizationId)&lt;=1">(QueryByParameter-QUMT_IN020011NL02): element hl7:custodianOrganizationId komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="count(hl7:patientId)&lt;=1">(QueryByParameter-QUMT_IN020011NL02): element hl7:patientId komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="count(hl7:registrationProcessCode)&lt;=1">(QueryByParameter-QUMT_IN020011NL02): element hl7:registrationProcessCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="count(hl7:registrationProcessCreationTime)&lt;=1">(QueryByParameter-QUMT_IN020011NL02): element hl7:registrationProcessCreationTime komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="count(hl7:registrationProcessLastUpdateTime)&lt;=1">(QueryByParameter-QUMT_IN020011NL02): element hl7:registrationProcessLastUpdateTime komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.6
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:queryId[not(@nullFlavor)]
Item: (QueryByParameter-QUMT_IN020011NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:queryId[not(@nullFlavor)]" id="d891642e73-false-d891809e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QueryByParameter-QUMT_IN020011NL02): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.6
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:statusCode[@code=doc('include/voc-2.16.840.1.113883.1.11.18899-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)]
Item: (QueryByParameter-QUMT_IN020011NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:statusCode[@code=doc('include/voc-2.16.840.1.113883.1.11.18899-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)]" id="d891642e78-false-d891824e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QueryByParameter-QUMT_IN020011NL02): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.18899-2011-07-26T000000.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(QueryByParameter-QUMT_IN020011NL02): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.18899 QueryStatusCode (2011-07-26T00:00:00)'.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.6
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:modifyCode
Item: (QueryByParameter-QUMT_IN020011NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:modifyCode" id="d891642e84-false-d891845e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QueryByParameter-QUMT_IN020011NL02): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.395-2011-07-26T000000.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(QueryByParameter-QUMT_IN020011NL02): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.395 ModifyIndicator (2011-07-26T00:00:00)'.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.6
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:responseModalityCode[@code=doc('include/voc-2.16.840.1.113883.1.11.394-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)]
Item: (QueryByParameter-QUMT_IN020011NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:responseModalityCode[@code=doc('include/voc-2.16.840.1.113883.1.11.394-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)]" id="d891642e88-false-d891868e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QueryByParameter-QUMT_IN020011NL02): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.394-2011-07-26T000000.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(QueryByParameter-QUMT_IN020011NL02): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.394 ResponseModality (2011-07-26T00:00:00)'.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.6
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:responsePriorityCode[@code=doc('include/voc-2.16.840.1.113883.1.11.91-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)]
Item: (QueryByParameter-QUMT_IN020011NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:responsePriorityCode[@code=doc('include/voc-2.16.840.1.113883.1.11.91-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)]" id="d891642e100-false-d891891e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QueryByParameter-QUMT_IN020011NL02): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.91-2011-07-26T000000.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(QueryByParameter-QUMT_IN020011NL02): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.91 QueryPriority (2011-07-26T00:00:00)'.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.6
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:initialQuantity
Item: (QueryByParameter-QUMT_IN020011NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:initialQuantity" id="d891642e104-false-d891912e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='INT' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QueryByParameter-QUMT_IN020011NL02): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:INT" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="INT"/>
        <let name="digitok" value="matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="$digitok or @nullFlavor">(QueryByParameter-QUMT_IN020011NL02): @value is geen geldig INT getal <value-of select="@value"/>
        </assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.6
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:initialQuantityCode
Item: (QueryByParameter-QUMT_IN020011NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:initialQuantityCode" id="d891642e105-false-d891928e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QueryByParameter-QUMT_IN020011NL02): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.19911-2011-07-26T000000.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(QueryByParameter-QUMT_IN020011NL02): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.19911 QueryRequestLimit (2011-07-26T00:00:00)'.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.6
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:executionAndDeliveryTime
Item: (QueryByParameter-QUMT_IN020011NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:executionAndDeliveryTime" id="d891642e107-false-d891949e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QueryByParameter-QUMT_IN020011NL02): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.6" test="not(*)">(QueryByParameter-QUMT_IN020011NL02): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.30
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:applicationId
Item: (QUMT_MT020021NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:applicationId" id="d891950e19-false-d891965e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="count(hl7:value[@root='2.16.840.1.113883.2.4.6.6'])&gt;=1">(QUMT_MT020021NL02): element hl7:value[@root='2.16.840.1.113883.2.4.6.6'] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="count(hl7:value[@root='2.16.840.1.113883.2.4.6.6'])&lt;=1">(QUMT_MT020021NL02): element hl7:value[@root='2.16.840.1.113883.2.4.6.6'] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.30
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:applicationId/hl7:value[@root='2.16.840.1.113883.2.4.6.6']
Item: (QUMT_MT020021NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:applicationId/hl7:value[@root='2.16.840.1.113883.2.4.6.6']" id="d891950e27-false-d891987e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QUMT_MT020021NL02): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="string(@root)=('2.16.840.1.113883.2.4.6.6')">(QUMT_MT020021NL02): de waarde van @root MOET '2.16.840.1.113883.2.4.6.6' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(QUMT_MT020021NL02): attribuut @root MOET datatype 'uid' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="not(@extension) or matches(@extension,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@extension,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@extension,'^[A-Za-z][A-Za-z\d\-]*$')">(QUMT_MT020021NL02): attribuut @extension MOET datatype 'uid' hebben</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.30
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:custodianOrganizationId
Item: (QUMT_MT020021NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:custodianOrganizationId" id="d891950e33-false-d892011e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="count(hl7:value[not(@nullFlavor)])&gt;=1">(QUMT_MT020021NL02): element hl7:value[not(@nullFlavor)] is mandatory [min 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.30
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:custodianOrganizationId/hl7:value[not(@nullFlavor)]
Item: (QUMT_MT020021NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:custodianOrganizationId/hl7:value[not(@nullFlavor)]" id="d891950e37-false-d892030e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QUMT_MT020021NL02): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="@extension">(QUMT_MT020021NL02): attribute @extension MOET aanwezig zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="not(@extension) or matches(@extension,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@extension,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@extension,'^[A-Za-z][A-Za-z\d\-]*$')">(QUMT_MT020021NL02): attribuut @extension MOET datatype 'uid' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="string(@root)=('2.16.528.1.1007.3.3') or not(@root)">(QUMT_MT020021NL02): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(QUMT_MT020021NL02): attribuut @root MOET datatype 'uid' hebben</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.30
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:patientId
Item: (QUMT_MT020021NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:patientId" id="d891950e43-false-d892057e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="count(hl7:value[not(@nullFlavor)])&gt;=1">(QUMT_MT020021NL02): element hl7:value[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="count(hl7:value[not(@nullFlavor)])&lt;=1">(QUMT_MT020021NL02): element hl7:value[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.30
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:patientId/hl7:value[not(@nullFlavor)]
Item: (QUMT_MT020021NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:patientId/hl7:value[not(@nullFlavor)]" id="d891950e47-false-d892079e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QUMT_MT020021NL02): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="not(@extension) or matches(@extension,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@extension,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@extension,'^[A-Za-z][A-Za-z\d\-]*$')">(QUMT_MT020021NL02): attribuut @extension MOET datatype 'uid' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="string(@root)=('2.16.840.1.113883.2.4.6.3') or not(@root)">(QUMT_MT020021NL02): de waarde van @root MOET '2.16.840.1.113883.2.4.6.3' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(QUMT_MT020021NL02): attribuut @root MOET datatype 'uid' hebben</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.30
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:registrationProcessCode
Item: (QUMT_MT020021NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:registrationProcessCode" id="d891950e53-false-d892103e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="count(hl7:value[not(@nullFlavor)])&gt;=1">(QUMT_MT020021NL02): element hl7:value[not(@nullFlavor)] is mandatory [min 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.30
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:registrationProcessCode/hl7:value[not(@nullFlavor)]
Item: (QUMT_MT020021NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:registrationProcessCode/hl7:value[not(@nullFlavor)]" id="d891950e57-false-d892122e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QUMT_MT020021NL02): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CD"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.30
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:registrationProcessCreationTime
Item: (QUMT_MT020021NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:registrationProcessCreationTime" id="d891950e61-false-d892135e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="count(hl7:value[not(@nullFlavor)])&gt;=1">(QUMT_MT020021NL02): element hl7:value[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="count(hl7:value[not(@nullFlavor)])&lt;=1">(QUMT_MT020021NL02): element hl7:value[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.30
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:registrationProcessCreationTime/hl7:value[not(@nullFlavor)]
Item: (QUMT_MT020021NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:registrationProcessCreationTime/hl7:value[not(@nullFlavor)]" id="d891950e69-false-d892157e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QUMT_MT020021NL02): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="IVL_TS"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.30
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:registrationProcessLastUpdateTime
Item: (QUMT_MT020021NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:registrationProcessLastUpdateTime" id="d891950e76-false-d892170e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="count(hl7:value)&gt;=1">(QUMT_MT020021NL02): element hl7:value is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="count(hl7:value)&lt;=1">(QUMT_MT020021NL02): element hl7:value komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.30
Context: /hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:registrationProcessLastUpdateTime/hl7:value
Item: (QUMT_MT020021NL02)
-->
    <rule context="/hl7:QUMT_IN020011NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:registrationProcessLastUpdateTime/hl7:value" id="d891950e80-false-d892192e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QUMT_MT020021NL02): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="IVL_TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="not(@root) or (string-length(@root)&gt;0 and not(matches(@root,'\s')))">(QUMT_MT020021NL02): attribuut @root MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.30" test="not(@extension) or (string-length(@extension)&gt;0 and not(matches(@extension,'\s')))">(QUMT_MT020021NL02): attribuut @extension MOET datatype 'cs' hebben</assert>
    </rule>
</pattern>